/*
 * Decompiled with CFR 0.152.
 */
package com.talpie.linker;

import com.talpie.linker.ClientListeners;
import com.talpie.linker.DataSocketClient;
import com.talpie.linker.Message;
import com.talpie.linker.StreamFrame;
import com.talpie.linker.StreamSocketClient;
import java.sql.Timestamp;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class ClientListenersHandler {
    private final Set<String> openDs = ConcurrentHashMap.newKeySet();
    private final Set<String> openStreams = ConcurrentHashMap.newKeySet();
    private final CopyOnWriteArrayList<ClientListeners.Lifecycle> lifecycle = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ClientListeners.Connection> connection = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ClientListeners.DataSocket> dataSocket = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ClientListeners.ControlMessage> controlMsg = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ClientListeners.DataMessage> dataMsg = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ClientListeners.Progress> progress = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ClientListeners.Ping> ping = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ClientListeners.StreamSocket> streamSocket = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ClientListeners.StreamMessage> streamMsg = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ClientListeners.StreamProgress> streamProgress = new CopyOnWriteArrayList();

    public AutoCloseable register(ClientListeners.Lifecycle l) {
        this.lifecycle.add(l);
        return () -> this.lifecycle.remove(l);
    }

    public AutoCloseable register(ClientListeners.Connection l) {
        this.connection.add(l);
        return () -> this.connection.remove(l);
    }

    public AutoCloseable register(ClientListeners.DataSocket l) {
        this.dataSocket.add(l);
        return () -> this.dataSocket.remove(l);
    }

    public AutoCloseable register(ClientListeners.ControlMessage l) {
        this.controlMsg.add(l);
        return () -> this.controlMsg.remove(l);
    }

    public AutoCloseable register(ClientListeners.DataMessage l) {
        this.dataMsg.add(l);
        return () -> this.dataMsg.remove(l);
    }

    public AutoCloseable register(ClientListeners.Progress l) {
        this.progress.add(l);
        return () -> this.progress.remove(l);
    }

    public AutoCloseable register(ClientListeners.Ping l) {
        this.ping.add(l);
        return () -> this.ping.remove(l);
    }

    public AutoCloseable register(ClientListeners.StreamSocket l) {
        this.streamSocket.add(l);
        return () -> this.streamSocket.remove(l);
    }

    public AutoCloseable register(ClientListeners.StreamMessage l) {
        this.streamMsg.add(l);
        return () -> this.streamMsg.remove(l);
    }

    public AutoCloseable register(ClientListeners.StreamProgress l) {
        this.streamProgress.add(l);
        return () -> this.streamProgress.remove(l);
    }

    public CopyOnWriteArrayList<ClientListeners.Lifecycle> lifecycle() {
        return this.lifecycle;
    }

    public CopyOnWriteArrayList<ClientListeners.Connection> connection() {
        return this.connection;
    }

    public CopyOnWriteArrayList<ClientListeners.DataSocket> dataSocket() {
        return this.dataSocket;
    }

    public CopyOnWriteArrayList<ClientListeners.ControlMessage> control() {
        return this.controlMsg;
    }

    public CopyOnWriteArrayList<ClientListeners.DataMessage> data() {
        return this.dataMsg;
    }

    public CopyOnWriteArrayList<ClientListeners.Progress> progress() {
        return this.progress;
    }

    public CopyOnWriteArrayList<ClientListeners.Ping> ping() {
        return this.ping;
    }

    public CopyOnWriteArrayList<ClientListeners.StreamSocket> streamSocket() {
        return this.streamSocket;
    }

    public CopyOnWriteArrayList<ClientListeners.StreamMessage> stream() {
        return this.streamMsg;
    }

    public CopyOnWriteArrayList<ClientListeners.StreamProgress> streamProgress() {
        return this.streamProgress;
    }

    public void start(Object caller) {
        Timestamp ts = ClientListenersHandler.now();
        this.lifecycle.forEach(l -> ClientListenersHandler.safe(() -> l.onStart(caller, ts)));
    }

    public void stop(Object caller) {
        Timestamp ts = ClientListenersHandler.now();
        this.lifecycle.forEach(l -> ClientListenersHandler.safe(() -> l.onStop(caller, ts)));
    }

    public void error(Object caller, Throwable err) {
        Timestamp ts = ClientListenersHandler.now();
        this.lifecycle.forEach(l -> ClientListenersHandler.safe(() -> l.onError(caller, ts, err)));
    }

    public void connected(Object caller) {
        Timestamp ts = ClientListenersHandler.now();
        this.connection.forEach(l -> ClientListenersHandler.safe(() -> l.onConnected(caller, ts)));
    }

    public void disconnected(Object caller, Throwable cause) {
        Timestamp ts = ClientListenersHandler.now();
        this.connection.forEach(l -> ClientListenersHandler.safe(() -> l.onDisconnected(caller, ts, cause)));
    }

    public void handshakeCompleted(Object caller) {
        Timestamp ts = ClientListenersHandler.now();
        this.connection.forEach(l -> ClientListenersHandler.safe(() -> l.onHandshakeCompleted(caller, ts)));
    }

    public void handshakeFailed(Object caller, Throwable cause) {
        Timestamp ts = ClientListenersHandler.now();
        this.connection.forEach(l -> ClientListenersHandler.safe(() -> l.onHandshakeFailed(caller, ts, cause)));
    }

    public void dataOpen(Object caller, DataSocketClient ds) {
        if (this.openDs.add(ds.getId())) {
            Timestamp ts = ClientListenersHandler.now();
            for (ClientListeners.DataSocket l : this.dataSocket) {
                ClientListenersHandler.safe(() -> l.onOpen(caller, ts, ds));
            }
        }
    }

    public void dataClose(Object caller, DataSocketClient ds) {
        if (this.openDs.remove(ds.getId())) {
            Timestamp ts = ClientListenersHandler.now();
            for (ClientListeners.DataSocket l : this.dataSocket) {
                ClientListenersHandler.safe(() -> l.onClose(caller, ts, ds));
            }
        }
    }

    public void dataHandshakeCompleted(Object caller, DataSocketClient ds) {
        Timestamp ts = ClientListenersHandler.now();
        this.dataSocket.forEach(l -> ClientListenersHandler.safe(() -> l.onHandshakeCompleted(caller, ts, ds)));
    }

    public void dataHandshakeFailed(Object caller, DataSocketClient ds, Throwable cause) {
        Timestamp ts = ClientListenersHandler.now();
        this.dataSocket.forEach(l -> ClientListenersHandler.safe(() -> l.onHandshakeFailed(caller, ts, ds, cause)));
    }

    public Message controlRequest(Object caller, Message msg) throws Exception {
        Timestamp ts = ClientListenersHandler.now();
        for (ClientListeners.ControlMessage l : this.controlMsg) {
            try {
                Message resp = l.onRequest(caller, ts, msg);
                if (resp == null) continue;
                return resp;
            }
            catch (Throwable t) {
                this.error(caller, t);
            }
        }
        return null;
    }

    public Message controlResponse(Object caller, Message msg) throws Exception {
        Timestamp ts = ClientListenersHandler.now();
        for (ClientListeners.ControlMessage l : this.controlMsg) {
            try {
                Message resp = l.onResponse(caller, ts, msg);
                if (resp == null) continue;
                return resp;
            }
            catch (Throwable t) {
                this.error(caller, t);
            }
        }
        return null;
    }

    public void ping(Object caller, Message msg) throws Exception {
        Timestamp ts = ClientListenersHandler.now();
        for (ClientListeners.Ping l : this.ping) {
            try {
                l.onPong(caller, ts, msg);
            }
            catch (Throwable t) {
                this.error(caller, t);
            }
        }
    }

    public byte[] feedPing(Object caller) throws Exception {
        for (ClientListeners.Ping l : this.ping) {
            try {
                byte[] resp = l.feedPing();
                if (resp == null) continue;
                return resp;
            }
            catch (Throwable t) {
                this.error(caller, t);
            }
        }
        return null;
    }

    public Message dataRequest(Object caller, DataSocketClient ds, Message msg) throws Exception {
        Timestamp ts = ClientListenersHandler.now();
        for (ClientListeners.DataMessage l : this.dataMsg) {
            try {
                Message resp = l.onRequest(caller, ts, ds, msg);
                if (resp == null) continue;
                return resp;
            }
            catch (Throwable t) {
                this.error(caller, t);
            }
        }
        return null;
    }

    public Message dataResponse(Object caller, DataSocketClient ds, Message msg) throws Exception {
        Timestamp ts = ClientListenersHandler.now();
        for (ClientListeners.DataMessage l : this.dataMsg) {
            try {
                Message resp = l.onResponse(caller, ts, ds, msg);
                if (resp == null) continue;
                return resp;
            }
            catch (Throwable t) {
                this.error(caller, t);
            }
        }
        return null;
    }

    public void progressRx(Object caller, Message m, long recvd, long total, int pct) {
        Timestamp ts = ClientListenersHandler.now();
        this.progress.forEach(l -> ClientListenersHandler.safe(() -> l.onProgressReceiving(caller, ts, m, recvd, total, pct)));
    }

    public void progressTx(Object caller, Message m, long sent, long total, int pct) {
        Timestamp ts = ClientListenersHandler.now();
        this.progress.forEach(l -> ClientListenersHandler.safe(() -> l.onProgressTransmitting(caller, ts, m, sent, total, pct)));
    }

    public void progressDataRx(Object caller, DataSocketClient ds, Message m, long recvd, long total, int pct) {
        Timestamp ts = ClientListenersHandler.now();
        this.progress.forEach(l -> ClientListenersHandler.safe(() -> l.onProgressDataReceiving(caller, ts, ds, m, recvd, total, pct)));
    }

    public void progressDataTx(Object caller, DataSocketClient ds, Message m, long sent, long total, int pct) {
        Timestamp ts = ClientListenersHandler.now();
        this.progress.forEach(l -> ClientListenersHandler.safe(() -> l.onProgressDataTransmitting(caller, ts, ds, m, sent, total, pct)));
    }

    public void streamOpen(Object caller, StreamSocketClient sc, String streamId) {
        Timestamp ts = ClientListenersHandler.now();
        this.streamSocket.forEach(l -> ClientListenersHandler.safe(() -> l.onOpen(caller, ts, sc, streamId)));
    }

    public void streamClose(Object caller, StreamSocketClient sc, String streamId) {
        Timestamp ts = ClientListenersHandler.now();
        this.streamSocket.forEach(l -> ClientListenersHandler.safe(() -> l.onClose(caller, ts, sc, streamId)));
    }

    public void streamHandshakeCompleted(Object caller, StreamSocketClient sc, String streamId) {
        Timestamp ts = ClientListenersHandler.now();
        this.streamSocket.forEach(l -> ClientListenersHandler.safe(() -> l.onHandshakeCompleted(caller, ts, sc, streamId)));
    }

    public void streamHandshakeFailed(Object caller, StreamSocketClient sc, String streamId, Throwable cause) {
        Timestamp ts = ClientListenersHandler.now();
        this.streamSocket.forEach(l -> ClientListenersHandler.safe(() -> l.onHandshakeFailed(caller, ts, sc, streamId, cause)));
    }

    public void streamMeta(Object caller, StreamSocketClient sc, String streamId, byte[] meta) {
        Timestamp ts = ClientListenersHandler.now();
        this.streamMsg.forEach(l -> ClientListenersHandler.safe(() -> l.streamMeta(caller, ts, sc, streamId, meta)));
    }

    public void streamFrame(Object caller, StreamSocketClient sc, StreamFrame frame) {
        Timestamp ts = ClientListenersHandler.now();
        this.streamMsg.forEach(l -> ClientListenersHandler.safe(() -> l.streamFrame(caller, ts, sc, frame)));
    }

    public void streamProgressRx(Object caller, StreamSocketClient sc, long frames, long totalBytesOnWire) {
        Timestamp ts = ClientListenersHandler.now();
        this.streamProgress.forEach(l -> ClientListenersHandler.safe(() -> l.streamProgressRx(caller, ts, sc, frames, totalBytesOnWire)));
    }

    public void streamProgressTx(Object caller, StreamSocketClient sc, long frames, long totalBytesOnWire) {
        Timestamp ts = ClientListenersHandler.now();
        this.streamProgress.forEach(l -> ClientListenersHandler.safe(() -> l.streamProgressTx(caller, ts, sc, frames, totalBytesOnWire)));
    }

    private static Timestamp now() {
        return new Timestamp(System.currentTimeMillis());
    }

    private static void safe(Runnable r) {
        try {
            r.run();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

